/*____________________________________________________________________________
		Copyright (C) 2000 Network Associates, Inc.
        All rights reserved.

        $Id: CSecurityToken.cpp,v 1.2 1999/12/07 06:08:01 nryan Exp $
____________________________________________________________________________*/

#include "pgpClassesConfig.h"
#include "CSecurityToken.h"

_USING_PGP

// Constants

// From Winnt.h.

#define TOKEN_ASSIGN_PRIMARY    (0x0001)
#define TOKEN_DUPLICATE         (0x0002)
#define TOKEN_IMPERSONATE       (0x0004)
#define TOKEN_QUERY             (0x0008)
#define TOKEN_QUERY_SOURCE      (0x0010)
#define TOKEN_ADJUST_PRIVILEGES (0x0020)
#define TOKEN_ADJUST_GROUPS     (0x0040)
#define TOKEN_ADJUST_DEFAULT    (0x0080)

#define TOKEN_ALL_ACCESS (STANDARD_RIGHTS_REQUIRED  |\
                          TOKEN_ASSIGN_PRIMARY      |\
                          TOKEN_DUPLICATE           |\
                          TOKEN_IMPERSONATE         |\
                          TOKEN_QUERY               |\
                          TOKEN_QUERY_SOURCE        |\
                          TOKEN_ADJUST_PRIVILEGES   |\
                          TOKEN_ADJUST_GROUPS       |\
                          TOKEN_ADJUST_DEFAULT)


#define TOKEN_READ       (STANDARD_RIGHTS_READ      |\
                          TOKEN_QUERY)


#define TOKEN_WRITE      (STANDARD_RIGHTS_WRITE     |\
                          TOKEN_ADJUST_PRIVILEGES   |\
                          TOKEN_ADJUST_GROUPS       |\
                          TOKEN_ADJUST_DEFAULT)

#define TOKEN_EXECUTE    (STANDARD_RIGHTS_EXECUTE)


// Types

// From Winnt.h.

typedef enum _TOKEN_TYPE 
{
    TokenPrimary = 1,
    TokenImpersonation

} TOKEN_TYPE, *PTOKEN_TYPE;


// Imported Functions

#define NTAPICPP extern "C" NTSYSAPI NTSTATUS NTAPI

NTAPICPP	ZwOpenProcess(PHANDLE ProcessHandle, ACCESS_MASK DesiredAccess, 
	POBJECT_ATTRIBUTES ObjectAttributes, PCLIENT_ID ClientId);

NTAPICPP	ZwOpenProcessToken(HANDLE ProcessHandle, 
	PGPUInt32 DesiredAccess, PHANDLE TokenHandle);

NTAPICPP	ZwDuplicateToken(HANDLE TokenHandle, PGPUInt32 DesiredAccess, 
	POBJECT_ATTRIBUTES ObjectAttributes, 
	SECURITY_IMPERSONATION_LEVEL ImpersonationLevel, TOKEN_TYPE TokenType, 
	PHANDLE phNewToken);


// Class CSecurityToken public member functions

CSecurityToken::CSecurityToken() 

	: mIsProcIdAssigned(FALSE), mIsTokenSet(FALSE), mProcessId(0), 
	mTokenHandle(NULL)
{
}

CSecurityToken::~CSecurityToken()
{
	if (IsTokenSet())
		RevertToSelf();
}

CComboError 
CSecurityToken::AssignProcessId(PGPUInt32 procId)
{
	pgpAssert(!IsProcessIdAssigned());
	pgpAssert(!IsTokenSet());

	CComboError error;

	error = DuplicateTokenOfProcess(procId, mTokenHandle);

	if (error.IsntError())
	{
		mIsProcIdAssigned = TRUE;
		mProcessId = procId;
	}

	return error;
}

void 
CSecurityToken::UnassignProcessId()
{
	pgpAssert(IsProcessIdAssigned());

	ZwClose(mTokenHandle);
	mTokenHandle = NULL;

	mIsProcIdAssigned = FALSE;
	mIsTokenSet = FALSE;
	mProcessId = 0;
}

void 
CSecurityToken::ImpersonateToken()
{
	pgpAssert(IsProcessIdAssigned());
	pgpAssert(!IsTokenSet());

	ZwSetInformationThread(NtCurrentThread(), ThreadImpersonationToken, 
		&mTokenHandle, sizeof(mTokenHandle));

	mIsTokenSet = TRUE;
}

void 
CSecurityToken::RevertToSelf()
{
	pgpAssert(IsProcessIdAssigned());
	pgpAssert(IsTokenSet());

	HANDLE nullToken = NULL;

	ZwSetInformationThread(NtCurrentThread(), ThreadImpersonationToken, 
		&nullToken, sizeof(nullToken));

	mIsTokenSet = FALSE;
}


CComboError 
CSecurityToken::DuplicateTokenOfProcess(PGPUInt32 procId, HANDLE& token)
{
	CLIENT_ID			clientId;
	CComboError			error;
	HANDLE				origToken, procHandle;
	OBJECT_ATTRIBUTES	objAttribs;

	InitializeObjectAttributes(&objAttribs, NULL, 0, NULL, NULL);

	clientId.UniqueThread = NULL;
	clientId.UniqueProcess = reinterpret_cast<void *>(procId);

	// Open a handle to the process.
	error.err = ZwOpenProcess(&procHandle, PROCESS_ALL_ACCESS, &objAttribs, 
		&clientId);

	if (error.HaveNonPGPError())
		error.pgpErr = kPGPError_SecurityOpFailed;

	if (error.IsntError())
	{
		// Open a handle to the process token.
		error.err = ZwOpenProcessToken(procHandle, TOKEN_ALL_ACCESS, 
			&origToken);

		if (error.HaveNonPGPError())
			error.pgpErr = kPGPError_SecurityOpFailed;

		// Duplicate the token.
		if (error.IsntError())
		{
			SECURITY_QUALITY_OF_SERVICE SQOS;

			SQOS.Length					= sizeof(SQOS);
			SQOS.ImpersonationLevel		= SecurityImpersonation;
			SQOS.ContextTrackingMode	= SECURITY_DYNAMIC_TRACKING;
			SQOS.EffectiveOnly			= FALSE;

			objAttribs.SecurityQualityOfService = &SQOS;

			error.err = ZwDuplicateToken(origToken, 
				TOKEN_QUERY | TOKEN_IMPERSONATE, &objAttribs, 
				SecurityAnonymous, TokenImpersonation, &token);

			if (error.HaveNonPGPError())
				error.pgpErr = kPGPError_SecurityOpFailed;

			// Close handle to the original token.
			ZwClose(origToken);
		}
	
		// Close handle to process.
		ZwClose(procHandle);
	}

	return error;
}
